// ------------------------------------
//       OnBoardC DOC Library
//            Version 1.0
//    by: Harry Konstas May.19/2000
// ------------------------------------
 
#include "OBL.h"

void CloseDoc(DOCFILE *pDoc)
{
  VoidPtr p;
  int n=0;

  // check if new Doc mode 
  if(pDoc->iBuff!=-1) {

    pDoc->pHeader->rNum = DmNumRecords(pDoc->db);

    // flush buffer
    if(pDoc->iBuff>0) {

      n = -1; // new record
      pDoc->buffer[pDoc->iBuff] = 0;
      pDoc->pHeader->DocSize += pDoc->iBuff;

      pDoc->hFile = DmNewRecord(pDoc->db,&n,StrLen(pDoc->buffer));
      p = MemHandleLock(pDoc->hFile);
      DmWrite(p,0,pDoc->buffer,StrLen(pDoc->buffer));
      MemHandleUnlock(pDoc->hFile);
      DmReleaseRecord(pDoc->db,n,true);
      pDoc->pHeader->rNum++;

    }

    // write header
    n = 0; 
    pDoc->hFile = DmNewRecord(pDoc->db,&n,sizeof(DOCHEADER));
    p = MemHandleLock(pDoc->hFile);
    DmWrite(p,0,pDoc->pHeader,sizeof(DOCHEADER));
    MemHandleUnlock(pDoc->hFile);
    DmReleaseRecord(pDoc->db,n,true);
    MemPtrFree(pDoc->pHeader);
     
  }
  else MemHandleUnlock(pDoc->hFile);

  MemHandleUnlock(pDoc->hBuff);
  DmCloseDatabase(pDoc->db);
  MemPtrFree(pDoc);

}

DOCFILE *OpenDoc(CharPtr fname)
{

  LocalID id;
  DOCFILE *pDoc;

  pDoc = MemPtrNew(sizeof(DOCFILE));

  pDoc->nRecs = 0;
  pDoc->iBuff = -1;   // read mode

  pDoc->hBuff = MemHandleNew(520);
  pDoc->buffer = MemHandleLock(pDoc->hBuff);

  id=DmFindDatabase(0,fname);
  pDoc->db = DmOpenDatabase(0,id,dmModeReadOnly);
  if(pDoc->db==0) return pDoc;

  // read Header + abort if compressed
  pDoc->hFile = DmQueryRecord(pDoc->db,0);
  pDoc->pHeader = MemHandleLock(pDoc->hFile);
  if(pDoc->pHeader->compressed==0x0002) return pDoc;

  // discard header (no longer needed)
  MemHandleUnlock(pDoc->hFile);

  pDoc->nRecs = DmNumRecords(pDoc->db); pDoc->iRec=1;
  pDoc->hFile = DmQueryRecord(pDoc->db,pDoc->iRec);
  pDoc->pData = MemHandleLock(pDoc->hFile);
  pDoc->RecSize = MemHandleSize(pDoc->hFile);

  return pDoc;

}

DOCFILE *NewDoc(CharPtr fname)
{

  int err;
  LocalID id;
  VoidPtr p;
  int n=-1;
  DOCFILE *pDoc;

  pDoc = MemPtrNew(sizeof(DOCFILE));
  pDoc->pHeader = MemPtrNew(sizeof(DOCHEADER));

  pDoc->hBuff = MemHandleNew(2100);
  pDoc->buffer = MemHandleLock(pDoc->hBuff);

  id = DmFindDatabase(0,fname);
  if(id) DmDeleteDatabase(0,id);

  err= DmCreateDatabase(0,fname,'REAd','TEXt',false);
  id = DmFindDatabase(0,fname);
  pDoc->db = DmOpenDatabase(0,id,dmModeReadWrite);

  pDoc->nRecs = -1; // new file
  pDoc->iBuff = 0;   // 1st byte
  pDoc->buffer[0] = 0;

  pDoc->pHeader->compressed = 0x0001;
  pDoc->pHeader->spare = 0x0000;
  pDoc->pHeader->DocSize = 0x00000000;
  pDoc->pHeader->rNum = 0x0000;
  pDoc->pHeader->rSize = 0x1000;
  pDoc->pHeader->position = 0x00000000;

  return pDoc;

}

int WriteDoc(DOCFILE *pDoc, CharPtr text)
{

  VoidPtr p;
  int n;
  char *t;

  t = text;

  while(*t) {

    pDoc->buffer[pDoc->iBuff++] = *t++;

    // flush + new record
    if(pDoc->iBuff>2040) {
      n=-1;
      pDoc->buffer[pDoc->iBuff] = 0;
      
      pDoc->hFile = DmNewRecord(pDoc->db,&n,StrLen(pDoc->buffer));
      p = MemHandleLock(pDoc->hFile);
      DmWrite(p,0,pDoc->buffer,StrLen(pDoc->buffer));
      MemHandleUnlock(pDoc->hFile);
      DmReleaseRecord(pDoc->db,n,true);

      pDoc->pHeader->DocSize += pDoc->iBuff;
      pDoc->iBuff=0;
      pDoc->buffer[0] =0;

    }

  }

}

void RewindDoc(DOCFILE *pDoc)
{

  if(pDoc->nRecs==0) return;

  pDoc->iRec=1;
  MemHandleUnlock(pDoc->hFile);
  pDoc->hFile = DmQueryRecord(pDoc->db,pDoc->iRec);
  pDoc->RecSize = MemHandleSize(pDoc->hFile);
  pDoc->pData = MemHandleLock(pDoc->hFile); 

}

int ReadDocLine(DOCFILE *pDoc)
{
  UInt i=0;
  char c=0;
  pDoc->buffer[i]=0;

  if(pDoc->nRecs==0) return 0;

  while(c!=0x0a && i<513) {

    if(pDoc->RecSize==0) {
      if(++pDoc->iRec >= pDoc->nRecs) return 0;
      MemHandleUnlock(pDoc->hFile);
      pDoc->hFile = DmQueryRecord(pDoc->db,pDoc->iRec);
      pDoc->RecSize = MemHandleSize(pDoc->hFile);
      pDoc->pData = MemHandleLock(pDoc->hFile);
    }
    
    c = *pDoc->pData;
    pDoc->buffer[i++]=c;
    pDoc->pData++; pDoc->RecSize--;

  } 

  pDoc->buffer[i]=0;
  return StrLen(pDoc->buffer);

}
